<?php
include_once 'root/config.php';

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: access");
header("Access-Control-Allow-Methods: POST, GET");
header("Content-Type: application/json; charset=UTF-8");
header('Access-Control-Allow-Credentials: true');
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

$api = $_SERVER['REQUEST_METHOD'];

if ($api == 'GET') {
    try {
        // Fetch all accessories
        $accessories_query = $dbh->query("SELECT accessory_id, accessory_type, name, img_url, acc_price FROM accessories");
        $accessories = $accessories_query->fetchAll(PDO::FETCH_ASSOC);

        // Add a common identifier for product type
        foreach ($accessories as &$accessory) {
            $accessory['product_type'] = 'accessory';
        }

        // Fetch gases (categories with details and packages)
        $gases_query = $dbh->query("
            SELECT 
                cd.cd_id as id,
                c.cat_name as name,
                c.cat_photo as img_url,
                cd.cat_detail as description,
                cd.category_price as price,
                cd.offer_price,
                cd.offer_status,
                p.package_name,
                'gas' as product_type
            FROM category_details cd
            LEFT JOIN categories c ON cd.cat_id = c.cat_id
            LEFT JOIN packages p ON cd.package_id = p.package_id
        ");
        $gases = $gases_query->fetchAll(PDO::FETCH_ASSOC);

        // Merge accessories and gases into one array
        $products = array_merge($accessories, $gases);

        if (!empty($products)) {
            http_response_code(200);
            echo json_encode([
                "message" => "Data retrieved successfully",
                "status" => "success",
                "products" => $products
            ]);
        } else {
            http_response_code(404);
            echo json_encode([
                "message" => "No data found",
                "status" => "failure"
            ]);
        }
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode([
            "message" => "Internal Server Error: " . $e->getMessage(),
            "status" => "failure"
        ]);
    }
}
?>
