<?php
// Set headers for JSON response
header("Content-Type: application/json");
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Function to send API requests
function sendApiRequest($url, $payload) {
    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => json_encode($payload),
        CURLOPT_HTTPHEADER => [
            'Content-Type: application/json'
        ],
        // Ensure that the certificate is valid and is at the correct path
        CURLOPT_CAINFO => '/yo.crt', // Update with the correct path to the certificate
        CURLOPT_SSL_VERIFYPEER => true, // Enforce SSL peer verification
    ]);

    $response = curl_exec($curl);
    if (curl_errno($curl)) {
        return ['error' => curl_error($curl)]; // Handle cURL error
    }
    curl_close($curl);

    // Decode JSON response and handle potential errors
    $decodedResponse = json_decode($response, true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        return ['error' => 'Invalid JSON response from API: ' . json_last_error_msg()];
    }

    return $decodedResponse;
}

// USSD Menu Handler
function handleUssdMenu($input) {
    // Default values for inputs
    $menuStep = isset($input['menuStep']) ? (int)$input['menuStep'] : 1;
    $userInput = isset($input['userInput']) ? (string)$input['userInput'] : '';

    // Debugging: Log incoming request data
    error_log("Received input: " . print_r($input, true));

    // Switch based on menu step
    switch ($menuStep) {
        case 1:
            // Step 1: Display menu options
            return [
                'response' => "Welcome to FlexiGas by NOOA Energies\n1. Buy Cooking Gas\n2. Buy Gas Accessories\n3. Buy Stoves and EPC",
                'nextStep' => 2
            ];

        case 2:
            // Step 2: Handle user selection
            $productKey = '';
            if ($userInput == '1') {
                $productKey = "1"; // Cooking Gas
            } elseif ($userInput == '2') {
                $productKey = "2"; // Gas Accessories
            } elseif ($userInput == '3') {
                $productKey = "3"; // Stoves and EPC
            } else {
                return ['response' => "Invalid option. Please try again.", 'nextStep' => 1];
            }

            // Payload for API request
            $payload = [
                "datetime" => date("YmdHis"), // Current datetime
                "anumbermsisdn" => "256740603514", // MSISDN (Your phone number)
                "signature" => "UTZUlSANgeRfo3936bTe2gOTkuK7dfl/+ydQHcK1q66DvaOoTKhVgwE9KM3sP0Pt9AbaL5S8E/0fPMJ0HUS9DiC7aN7Nkt7UNDVu1HZsdJO3wOf5poLdM9+K/dXP2EAFx6suW8oq5ZnuNub1qpZaPtLVO+9ffU7G4tqpE3ZdeQRTGJQbcEYbb5dWh8RTwDEaVXnJHU2qqxAkVVSTy13bT4ggD7ernl697/EeB0m1Sc6ZOooh7bG2QFuZ5pWpVMRTTt+SZt4V8PWsMO4wBMTvD7ID7al0tOPZxUN7ZiuTINYVB6Pq9fmQy/0CJ/YBIdaueclnR1e2GQiO0Py+O8wKJg==", // Signature
                "product_key" => $productKey // Selected product
            ];

            // Send API request
            $response = sendApiRequest('https://mobileapi.flexigas.co/all-products', $payload);

            // Check for errors in API response
            if (isset($response['error'])) {
                return ['response' => "Error communicating with the server: " . $response['error'], 'nextStep' => 1];
            }

            // Validate response
            if (isset($response['validated']) && $response['validated']) {
                return [
                    'response' => urldecode($response['multi_step_product']['display_message']),
                    'nextStep' => 3,
                    'productData' => $response['multi_step_product']
                ];
            } else {
                return ['response' => "Error: Invalid input. Please try again.", 'nextStep' => 1];
            }

        case 3:
            // Step 3: Handle product selection
            $productList = isset($input['productData']['multi_step_product_list']) ? $input['productData']['multi_step_product_list'] : [];
            foreach ($productList as $product) {
                if ($product['expected_user_input'] == $userInput) {
                    return [
                        'response' => urldecode($product['payment_confirmation']),
                        'nextStep' => 4,
                        'paymentData' => $product
                    ];
                }
            }

            return ['response' => "Invalid selection. Please try again.", 'nextStep' => 2];

        case 4:
            // Step 4: Handle payment confirmation
            if ($userInput == '1') {
                return ['response' => "A mobile money transaction has been initiated. Please approve.", 'nextStep' => 5];
            } else {
                return ['response' => "Transaction cancelled.", 'nextStep' => 1];
            }

        default:
            return ['response' => "Invalid input. Please try again.", 'nextStep' => 1];
    }
}

// Sample Input (for testing)
$input = json_decode(file_get_contents("php://input"), true);

// Debugging: Log the input for troubleshooting
error_log("Received input: " . print_r($input, true));

// Validate input (check required fields)
if (empty($input['menuStep']) || empty($input['userInput'])) {
    echo json_encode(['error' => 'Missing required input parameters.']);
    exit;
}

// Process Input
$response = handleUssdMenu($input);

// Return Response
echo json_encode($response);
?>
