<?php 
    include_once 'root/config.php';
    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Headers: access");
    header("Access-Control-Allow-Methods: POST, GET");
    header("Content-Type: application/json; charset=UTF-8");
    header('Access-Control-Allow-Credentials: true');
    header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

    // Create an API variable to get HTTP method dynamically
    $api = $_SERVER['REQUEST_METHOD'];

    if ($api == 'GET') {
        $accessory_type = isset($_GET['accessory_type']) ? test_input($_GET['accessory_type']) : '';

        if (!empty($accessory_type)) {
            // Prepare the SQL statement to prevent SQL injection
            $stmt = $dbh->prepare("SELECT * FROM accessories WHERE accessory_type = :accessory_type");
            $stmt->bindParam(':accessory_type', $accessory_type);
            $stmt->execute();

            $rows = array();

            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                // Add accessory details to the response
                $rows[] = array(
                    "accessory_id" => $row['accessory_id'],
                    "img_url" => $row['img_url'],
                    "accessory_type" => $row['accessory_type'],
                    "name" => $row['name'],
                    "acc_price" => $row['acc_price'],
                    "package_id" => 3,
                    "package" => "Accessories",
                );
            }

            if (count($rows) > 0) {
                http_response_code(200);
                echo json_encode(array("message" => "Accessories returned successfully", "status" => "success", "data" => $rows));
            } else {
                http_response_code(404);
                echo json_encode(array("message" => "No accessories found for this type", "status" => false));
            }
        } else {
            http_response_code(400);
            echo json_encode(array("message" => "Missing required parameter accessory_type", "status" => false));
        }
    } else {
        http_response_code(405);
        echo json_encode(array("message" => "Method Not Allowed", "status" => false));
    }
?>
