<?php 
    include_once 'root/config.php';
    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Headers: access");
    header("Access-Control-Allow-Methods: POST, GET");
    header("Content-Type: application/json; charset=UTF-8");
    header('Access-Control-Allow-Credentials: true');
    header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

    // create a api variable to get HTTP method dynamically
    $api = $_SERVER['REQUEST_METHOD'];
    // cd_id, cat_id, cat_detail, package_id, category_price, offer_price, offer_status

    if ($api == 'GET') {
        $sql = $dbh->query("
            SELECT 
                cd.cd_id, cd.cat_id, cd.cat_detail, cd.package_id, cd.category_price, cd.offer_price, cd.offer_status,
                p.package_name,
                c.cat_name, c.cat_photo
            FROM category_details cd
            JOIN packages p ON cd.package_id = p.package_id
            JOIN categories c ON cd.cat_id = c.cat_id
            WHERE cd.offer_status = '1'
        ");
        $rows = array();

        while ($row = $sql->fetch(PDO::FETCH_ASSOC)) {
            $rows[] = array(
                "cd_id" => $row["cd_id"],
                "cat_id" => $row["cat_id"],
                "cat_detail" => $row["cat_detail"],
                "package_id" => $row["package_id"],
                "package_name" => $row["package_name"],
                "cat_name" => $row["cat_name"],
                "cat_photo" => $row["cat_photo"],
                "category_price" => $row["category_price"],
                "offer_price" => $row["offer_price"],
                "offer_status" => $row["offer_status"]
            );
        }
        if ($sql) {
            http_response_code(200);
            echo json_encode(array("message" => "Offer returned successfully","status"=> "success","data" => $rows));
        } else {
            http_response_code(303);
            echo json_encode(array("message" => "Offer of this id not found", "status"=> false));
        }
    } else {
        http_response_code(303);
        echo json_encode(array("message" => "Wrong Method used", "status"=> false));
    }
?>
