<?php 
    include_once 'root/config.php';
    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Headers: access");
    header("Access-Control-Allow-Methods: POST, GET");
    header("Content-Type: application/json; charset=UTF-8");
    header('Access-Control-Allow-Credentials: true');
    header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

    // create a api variable to get HTTP method dynamically
    $api = $_SERVER['REQUEST_METHOD'];
    // cd_id, cat_id, cat_detail, package_id, category_price, offer_price, offer_status

    if ($api == 'GET') {
        $cd_id = isset($_GET['cd_id']) ? test_input($_GET['cd_id']) : '';

        if (!empty($cd_id)) {
            $sql = $dbh->query("SELECT * FROM category_details WHERE cd_id = '$cd_id' AND offer_status = '1'");
            $rows = array();

            while ($row = $sql->fetch(PDO::FETCH_ASSOC)) {
                extract($row);
                $rows[] = array(
                    "cd_id" => $cd_id,
                    "cat_id" => $cat_id,
                    "cat_detail" => $cat_detail,
                    "package_id" => $package_id,
                    "category_price" => $category_price,
                    "offer_price" => $offer_price,
                    "offer_status" => $offer_status
                );
            }
            if ($sql->rowCount() > 0) {
                http_response_code(200);
                echo json_encode(array("message" => "Offer returned successfully","status"=> "success","data" => $rows));
            } else {
                http_response_code(303);
                echo json_encode(array("message" => "Offer of this id not found", "status"=> false));
            }
        } else {
            http_response_code(303);
            echo json_encode(array("message" => "Missing required value cd_id", "status"=> false));
        }
    } else {
        http_response_code(303);
        echo json_encode(array("message" => "Wrong Method used", "status"=> false));
    }
?>
