<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

include_once 'root/config.php';
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: access");
header("Access-Control-Allow-Methods: POST, GET");
header("Content-Type: application/json; charset=UTF-8");
header('Access-Control-Allow-Credentials: true');
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

$api = $_SERVER['REQUEST_METHOD'];

if ($api == 'GET') {
    $userid = isset($_GET['userid']) ? test_input($_GET['userid']) : '';

    if (!empty($userid)) {
        $query = "
            SELECT
                c.cart_id,
                c.userid,
                c.cat_id,
                a.accessory_id,
                c.cart_status,
                c.cart_qnty,
                c.cart_price,
                c.cart_total_price,
                c.cart_date,
                c.invoice,
                a.name AS product_name,
                a.accessory_type,
                a.img_url AS product_photo,
                c.package_id
            FROM cart c
            LEFT JOIN accessories a ON c.cat_id = a.accessory_id
            WHERE c.userid = :userid 
            AND c.cart_status = 'Pending'
            AND c.cart_date = :today
            AND (c.package_id = 3 OR c.cat_id IS NULL)

            UNION ALL
            
            SELECT
                c.cart_id,
                c.userid,
                c.cat_id,
                NULL AS accessory_id,
                c.cart_status,
                c.cart_qnty,
                c.cart_price,
                c.cart_total_price,
                c.cart_date,
                c.invoice,
                cat.cat_name AS product_name,
                NULL AS accessory_type,
                cat.cat_photo AS product_photo,
                c.package_id
            FROM cart c
            LEFT JOIN categories cat ON c.cat_id = cat.cat_id
            WHERE c.userid = :userid 
            AND c.cart_status = 'Pending'
            AND c.cart_date = :today
            AND c.package_id != 3
        ";

        $stmt = $dbh->prepare($query);
        $stmt->execute([':userid' => $userid, ':today' => $today]);

        // Fetch results
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        // Return results
        echo json_encode(array("message" => "Data fetched successfully", "data" => $rows));
    } else {
        http_response_code(400);
        echo json_encode(array("message" => "User ID is required", "status" => "error"));
    }
} else {
    http_response_code(405);
    echo json_encode(array("message" => "Wrong method used", "status" => "error"));
}
?>
