<?php
// Database connection details
include_once '../../root/config.php';

// Set CORS headers
header("Access-Control-Allow-Origin: *"); // Allow requests from any origin
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With,Origin, Accept"); 

if (isset($_GET['q'])) {
    $searchTerm = $_GET['q'];

    $stmt = $dbh->prepare("SELECT 
        job_id,
        job_cat_id,
        job_title, 
        job_type, 
        job_slug, 
        job_location,
        job_country,
        job_amount
    FROM jobs 
    WHERE (
        job_id LIKE :searchTerm 
        OR job_cat_id LIKE :searchTerm 
        OR job_title LIKE :searchTerm 
        OR job_type LIKE :searchTerm
        OR job_slug LIKE :searchTerm
        OR job_location LIKE :searchTerm
        OR job_country LIKE :searchTerm
        OR job_amount LIKE :searchTerm
    )
    ORDER BY job_id DESC
    ");
    $stmt->bindValue(':searchTerm', '%' . $searchTerm . '%', PDO::PARAM_STR);
    $stmt->execute();

    $data = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $data[] = $row;
    }

    header('Content-Type: application/json');
    echo json_encode($data);
}
?>
