<?php
include_once 'root/config.php';

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: access");
header("Access-Control-Allow-Methods: GET");
header("Content-Type: application/json; charset=UTF-8");
header('Access-Control-Allow-Credentials: true');
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

$api = $_SERVER['REQUEST_METHOD'];

if ($api == 'GET') {
    // Check if product_id and product_type are provided
    $product_id = isset($_GET['product_id']) ? intval($_GET['product_id']) : null;
    $product_type = isset($_GET['product_type']) ? $_GET['product_type'] : null;

    if ($product_id && $product_type) {
        try {
            $query = null;

            if ($product_type === 'accessory') {
                // Fetch accessory details
                $query = $dbh->prepare("SELECT accessory_id, accessory_type, name, img_url, acc_price FROM accessories WHERE accessory_id = :product_id");
            } elseif ($product_type === 'gas') {
                // Fetch gas details
                $query = $dbh->prepare("
                    SELECT 
                        cd.cd_id as id,
                        c.cat_name as name,
                        c.cat_photo as img_url,
                        cd.cat_detail as description,
                        cd.category_price as price,
                        cd.offer_price,
                        cd.offer_status,
                        p.package_name
                    FROM category_details cd
                    LEFT JOIN categories c ON cd.cat_id = c.cat_id
                    LEFT JOIN packages p ON cd.package_id = p.package_id
                    WHERE cd.cd_id = :product_id
                ");
            } else {
                http_response_code(400);
                echo json_encode([
                    "message" => "Invalid product type",
                    "status" => "failure"
                ]);
                exit();
            }

            // Execute the query
            $query->bindParam(':product_id', $product_id, PDO::PARAM_INT);
            $query->execute();

            $product = $query->fetch(PDO::FETCH_ASSOC);

            if ($product) {
                http_response_code(200);
                echo json_encode($product);
            } else {
                http_response_code(404);
                echo json_encode([
                    "message" => "Product not found",
                    "status" => "failure"
                ]);
            }
        } catch (PDOException $e) {
            http_response_code(500);
            echo json_encode([
                "message" => "Internal Server Error: " . $e->getMessage(),
                "status" => "failure"
            ]);
        }
    } else {
        http_response_code(400);
        echo json_encode([
            "message" => "Missing product_id or product_type",
            "status" => "failure"
        ]);
    }
}
?>
