# YO USSD Integration Project

This project integrates with the FlexiGas API using a secure POST method.

## Setup Instructions

1. Clone/download this project into your localhost root directory (`htdocs` for XAMPP or `www` for WAMP).
2. Download the SSL certificate from [GitHub](https://github.com/YO-Uganda/YoPaymentsPHP/blob/master/Yo_Uganda_Public_Sandbox_Certificate.crt) and save it as `certificate.crt` in the project root.
3. Open `config.php` and configure the required fields (e.g., `default_msisdn`, `signature`, `default_product_key`).
4. Run the project by accessing `http://localhost/yo_ussd_integration/post_request.php` from your browser.

## File Structure

- `post_request.php`: Main script to execute the API call.
- `config.php`: Stores API and default settings.
- `helpers.php`: Contains reusable functions for sending requests and logging errors.
- `logs/error_log.txt`: Captures error messages for debugging.
- `certificate.crt`: SSL certificate for secure API communication.

## Testing

1. Verify the `certificate.crt` file is correctly placed.
2. Confirm that `config.php` contains the correct API URL, MSISDN, and signature.
3. Access `post_request.php` in your browser and inspect the response.

## Troubleshooting

- Check `logs/error_log.txt` for error details.
- Ensure the server has internet access to connect to the API.
