<?php 
    include_once 'root/config.php';
    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Headers: access");
    header("Access-Control-Allow-Methods: POST, GET");
    header("Content-Type: application/json; charset=UTF-8");
    header('Access-Control-Allow-Credentials: true');
    header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

    // create a api variable to get HTTP method dynamically
    $api = $_SERVER['REQUEST_METHOD'];

    if ($api == 'GET') {
        $sql = $dbh->query("SELECT * FROM categories ");
        $rows = array();

        while ($row = $sql->fetch(PDO::FETCH_ASSOC)) {
            extract($row);
            $rows[] = array(
                "cat_id" => $cat_id,
                "cat_name" => $cat_name,
                "cat_photo" => $cat_photo
            );
        }
        if ($rows) {
            http_response_code(200);
            echo json_encode(array("message" => "Categories successfully returned", "status"=> "success", "data" => $rows));
        } else {
            http_response_code(303);
            echo json_encode(array("message" => "No categories found", "status"=> false));
        }
    }
?>
