<?php 
    include_once 'root/config.php';
    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Headers: access");
    header("Access-Control-Allow-Methods: POST, GET");
    header("Content-Type: application/json; charset=UTF-8");
    header('Access-Control-Allow-Credentials: true');
    header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
    
    // create a api variable to get HTTP method dynamically
    $api = $_SERVER['REQUEST_METHOD'];

    if ($api == 'GET') {
        $cat_id = isset($_GET['cat_id']) ? test_input($_GET['cat_id']) : '';

        if (!empty($cat_id)) {
            // Fetch all the packages
            $check_cat_id_availability = dbRow("SELECT * FROM categories WHERE cat_id = '$cat_id'");

            if($check_cat_id_availability) {
                $sql = $dbh->prepare("SELECT packages.package_id, packages.package_name, category_details.cat_id FROM packages LEFT JOIN category_details ON packages.package_id = category_details.package_id AND category_details.cat_id = :cat_id GROUP BY packages.package_id, packages.package_name");
                $sql->bindParam(':cat_id', $cat_id);
                $sql->execute();
                $package_details = $sql->fetchAll(PDO::FETCH_ASSOC);

                if ($package_details) {
                    http_response_code(200);
                    echo json_encode(array("message" => "Package details found and returned successfully", "status" => "success", "data" => $package_details));
                } else {
                    http_response_code(303);
                    echo json_encode(array("message" => "No package found for the given category id", "status" => false));
                }
            } else {
                http_response_code(303);
                echo json_encode(array("message" => "No category found with this id", "status" => false));
            }
        } else {
            http_response_code(400);
            echo json_encode(array("message" => "Required cat_id missing", "status" => "false"));
        }
    } else {
        http_response_code(400);
        echo json_encode(array("message" => "Wrong Method used", "status" => false));
    }
?>
