<?php 
    include_once 'root/config.php';
    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Headers: access");
    header("Access-Control-Allow-Methods: POST, GET");
    header("Content-Type: application/json; charset=UTF-8");
    header('Access-Control-Allow-Credentials: true');
    header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

    // create a api variable to get HTTP method dynamically
    $api = $_SERVER['REQUEST_METHOD'];

    if ($api == 'GET') {
        $sql = $dbh->query("SELECT * FROM packages");
        $rows = array();

        while ($row = $sql->fetch(PDO::FETCH_ASSOC)) {
            extract($row);
            $rows[] = array(
                "package_id" => $package_id,
                "package_name" => $package_name
            );
        }
        if ($rows) {
            http_response_code(200);
            echo json_encode(array("message" => "Packages returned successfully","status"=> "success","data" => $rows));
        } else {
            http_response_code(303);
            echo json_encode(array("message" => "Packages not found", "status"=> false));
        }
    }
?>
