<?php

// Function to send a POST request
function send_post_request($url, $payload, $certificate_path = null) {
    $ch = curl_init($url);
    $json_payload = json_encode($payload);

    // Set cURL options
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $json_payload);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Content-Length: ' . strlen($json_payload)
    ]);

    // SSL certificate validation
    if ($certificate_path && file_exists(__DIR__ . '/' . $certificate_path)) {
        curl_setopt($ch, CURLOPT_CAINFO, __DIR__ . '/' . $certificate_path);
    } else if ($certificate_path) {
        log_error('Certificate file not found: ' . __DIR__ . '/' . $certificate_path);
    }

    // Execute the cURL request
    $response = curl_exec($ch);

    // Check for cURL errors
    if (curl_errno($ch)) {
        log_error('cURL Error: ' . curl_error($ch));
        curl_close($ch);
        return false;
    }

    curl_close($ch);
    return $response;
}

// Function to log errors
function log_error($message) {
    $log_file = __DIR__ . '/logs/error_log.txt';

    // Ensure the logs directory exists
    if (!is_dir(__DIR__ . '/logs')) {
        mkdir(__DIR__ . '/logs', 0755, true);
    }

    // Write to log file
    file_put_contents($log_file, date('[Y-m-d H:i:s] ') . $message . PHP_EOL, FILE_APPEND);
}

?>
