<?php
// Include configuration and helper functions
$config = include('config.php');
include('helpers.php');
require 'vendor/autoload.php';



// Build the payload
$payload = [
    'datetime' => date('YmdHis'), // Current timestamp
    'anumbermsisdn' => $config['default_msisdn'], // MSISDN
    'signature' => $config['signature'], // Provided signature
    'product_key' => $config['default_product_key'] // Product key
];

// Send the POST request
$response = send_post_request($config['api_endpoint'], $payload, $config['certificate_path']);

// Display the response or handle errors
if ($response) {
    echo "API Response:\n";
    print_r(json_decode($response, true));
} else {
    echo "Error occurred. Check logs for details.";
}
